<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="html" indent="no" encoding="UTF-8" />

    <!-- For local tests only -->
    <!-- <xsl:param name="metrics_url" select="'./TESTS/output.json'" /> -->
    <!-- <xsl:param name="index_url" select="'./index.html'" /> -->

    <xsl:param name="metrics_url" />
    <xsl:param name="columns_url" />
    
    <xsl:template match="/">
        <xsl:variable name="html" select="unparsed-text($columns_url)" />
        <xsl:value-of select="substring-before($html, 'pl_data_pl')" disable-output-escaping="yes"/>
        <xsl:value-of select="unparsed-text($metrics_url)"/>
        <xsl:value-of select="substring-after($html, 'pl_data_pl')" disable-output-escaping="yes"/>
    </xsl:template>
</xsl:stylesheet>